ADMIN
user : adminganteng@admin.com
pass : password

# 🌙 Sistem Informasi Masjid Digital

![Logo Aplikasi](https://via.placeholder.com/100)

**Sistem Informasi Masjid Digital** adalah solusi modern berbasis web untuk manajemen masjid, dibangun dengan Laravel 12. Aplikasi ini menampilkan informasi masjid secara real-time di layar TV digital dengan desain dinamis dan responsif.

---

## 📌 Tentang Aplikasi Ini

Aplikasi ini dirancang untuk:
- 🕌 Menampilkan jadwal sholat
- 📢 Menyampaikan pengumuman masjid
- 💰 Menyajikan laporan keuangan secara transparan
- 📅 Menampilkan kalender kegiatan
- 📺 Mengelola tampilan digital di layar TV

---

## ✨ Fitur Utama

| Fitur | Deskripsi |
|------|-----------|
| 📺 **Tampilan TV Dinamis** | Informasi masjid real-time di layar TV |
| 🕐 **Jadwal Sholat Otomatis** | Update waktu sholat otomatis berdasarkan lokasi |
| 💸 **Laporan Keuangan** | Grafik & detail pemasukan/pengeluaran |
| 📢 **Pengumuman Digital** | Teks berjalan dengan efek animasi |
| 📆 **Kalender Kegiatan** | Jadwal kegiatan masjid yang interaktif |
| 📱 **Responsive Design** | Tampilan optimal di TV, komputer, dan mobile |

---

## 🖥️ Fitur Tampilan TV

1. 🕒 **Tampilan Waktu**
- Menampilkan waktu sholat, Hijriah & Masehi
2. 📰 **Running Text**
- Pengumuman bergulir dengan kecepatan yang bisa diatur
3. 🖼️ **Animasi Kaligrafi**
- Efek visual Islami yang menawan
4. 🧩 **Multi-Layout**
- Beragam tampilan bisa dipilih sesuai kebutuhan

---

## 🔐 Fitur Admin

### 🎛️ Manajemen Konten
- Mengatur jadwal sholat & imam
- Posting pengumuman dan kegiatan
- Input data keuangan
- Pengaturan tampilan TV
- Upload gambar/dokumen

### 🛡️ Sistem Keamanan
- Login 2FA (dua faktor)
- Akses berbasis role
- Log aktivitas admin
- Backup otomatis
- Proteksi serangan siber

---

## 🧪 Teknologi yang Digunakan

| Teknologi | Deskripsi |
|-----------|-----------|
| ![Laravel](https://laravel.com/img/logomark.min.svg) **Laravel 12** | Framework backend |
| ![Bootstrap](https://getbootstrap.com/docs/5.0/assets/brand/bootstrap-logo.svg) **Bootstrap 5** | CSS frontend |
| ![Vue.js](https://vuejs.org/images/logo.png) **Vue.js** | UI interaktif |
| ![MySQL](https://www.mysql.com/common/logos/logo-mysql-170x115.png) **MySQL** | Database system |

---

## 🛠️ Panduan Penggunaan

### ▶️ Menampilkan di TV
1. Buka browser di TV
2. Akses alamat aplikasi, misal: `http://masjidanda.tv`
3. Tekan `F11` untuk mode fullscreen
4. Atur resolusi layar
5. Informasi akan tampil otomatis

### ⏰ Update Jadwal Sholat
1. Login sebagai admin
2. Akses menu **Jadwal Sholat**
3. Input waktu sesuai lokasi
4. Atur imam & muadzin
5. Sistem akan memperbarui otomatis

### 📢 Posting Pengumuman
1. Login sebagai admin
2. Masuk menu **Pengumuman**
3. Buat konten baru
4. Atur tanggal & prioritas
5. Muncul otomatis di running text

---

## 👨‍💻 Developer

Dikembangkan oleh  
**[Ali Mochtar Development System](https://wa.me/628179851011)**  
📱 Kontak: _{{ kontak admin }}_

🛠️ **Versi Aplikasi:** 2.0.0  
🗓️ **Update Terakhir:** {{ Tanggal Hari Ini }}

---




Deskripsi Diagram untuk Aplikasi
1. Diagram untuk Skenario Lokal (Komputer sebagai Server)
Konsep Diagram: Diagram ini menunjukkan arsitektur sistem saat aplikasi dijalankan secara lokal menggunakan komputer sebagai server, dengan TV sebagai perangkat tampilan.

Elemen Diagram:

Komputer (Server Lokal): Bertindak sebagai server yang menjalankan aplikasi berbasis Laravel 12, menyimpan database MySQL, dan menangani logika backend.
TV: Perangkat tampilan yang mengakses aplikasi melalui browser (misalnya, Chrome) dengan URL lokal (contoh: http://192.168.x.x).
Admin (Perangkat Pengelola): Perangkat (PC/laptop) yang digunakan admin untuk mengelola konten melalui antarmuka admin.
Jaringan Lokal (LAN): Menghubungkan komputer server, TV, dan perangkat admin melalui Wi-Fi atau kabel Ethernet.
Database (MySQL): Berjalan di komputer server, menyimpan data seperti jadwal sholat, pengumuman, dan laporan keuangan.
Alur Data:
Admin mengakses antarmuka admin melalui browser untuk mengelola konten (jadwal sholat, pengumuman, keuangan).
Komputer server memproses permintaan dan mengirimkan tampilan dinamis ke TV melalui jaringan lokal.
TV menampilkan informasi seperti jadwal sholat, running text, dan animasi kaligrafi secara real-time.
Desain Visual:

Gunakan ikon persegi untuk komputer (dengan label "Server Lokal - Laravel 12 + MySQL").
Gambar ikon TV dengan layar yang menampilkan elemen seperti jam, running text, dan kaligrafi.
Tambahkan ikon laptop untuk perangkat admin.
Hubungkan elemen dengan panah berlabel "HTTP Request" (dari TV/admin ke server) dan "Data Response" (dari server ke TV).
Gunakan warna biru (#0a4d68) dan hijau (#00a86b) sesuai tema aplikasi untuk garis dan elemen.
Tambahkan latar belakang masjid atau kaligrafi Islami untuk estetika.
2. Diagram untuk Skenario Hosting/Online
Konsep Diagram: Diagram ini menggambarkan arsitektur sistem saat aplikasi di-host di server cloud, dengan TV dan perangkat admin mengaksesnya melalui internet.

Elemen Diagram:

Cloud Server: Server berbasis cloud (misalnya, AWS, Google Cloud) yang menjalankan aplikasi Laravel 12 dan database MySQL.
TV: Mengakses aplikasi melalui browser dengan URL publik (contoh: http://masjidanda.tv).
Admin (Perangkat Pengelola): Mengakses antarmuka admin melalui browser dari mana saja dengan koneksi internet.
Internet: Menghubungkan TV, admin, dan cloud server.
Database (MySQL): Dihost di cloud server, menyimpan semua data aplikasi.
Alur Data:
Admin mengelola konten melalui antarmuka admin yang diakses via internet.
Cloud server memproses permintaan dan mengirimkan tampilan dinamis ke TV.
TV menampilkan informasi real-time seperti jadwal sholat, pengumuman, dan laporan keuangan.
Keamanan: Tambahkan ikon kunci untuk menunjukkan fitur keamanan seperti verifikasi dua faktor dan proteksi cyber.
Desain Visual:

Gambar ikon awan untuk cloud server dengan label "Cloud Server - Laravel 12 + MySQL".
Ikon TV dengan tampilan serupa (jam, running text, kaligrafi).
Ikon laptop untuk admin, dengan panah menunjuk ke cloud server.
Gunakan garis putus-putus untuk menunjukkan koneksi internet.
Tambahkan ikon kunci atau perisai di dekat cloud server untuk menandakan keamanan.
Gunakan palet warna biru dan hijau, dengan aksen emas untuk elemen kaligrafi.
Latar belakang dengan motif Islami untuk menambah daya tarik visual.
Contoh Struktur Diagram (Teks Berbasis)
Skenario Lokal:

text

Ciutkan

Wrap

Salin
[Admin Laptop] --> [LAN] --> [Komputer Server: Laravel 12 + MySQL]
|
|
[TV: Browser]
Skenario Hosting/Online:

text

Ciutkan

Wrap

Salin
[Admin Laptop] --> [Internet] --> [Cloud Server: Laravel 12 + MySQL]
|
|
[TV: Browser]
Jika Anda Menginginkan Visualisasi dengan Chart.js
Jika Anda menginginkan representasi sederhana menggunakan Chart.js (meskipun Chart.js lebih cocok untuk grafik, bukan diagram alur), saya bisa membuat diagram alur sederhana dalamFluid: Saya bisa membuat deskripsi diagram yang menarik untuk aplikasi Anda dengan dua skenario: lokal (menggunakan komputer sebagai server) dan hosting/online (menggunakan server berbasis cloud). Namun, karena Anda meminta "gambar", saya perlu konfirmasi: Apakah Anda ingin saya menghasilkan diagram visual (misalnya, menggunakan alat seperti Chart.js untuk representasi sederhana atau kode visual lainnya) atau hanya mendeskripsikan diagram secara rinci untuk Anda buat menggunakan alat desain seperti Figma, Canva, atau lainnya? Saya akan berasumsi Anda menginginkan deskripsi terperinci terlebih dahulu, dan jika Anda mengonfirmasi kebutuhan visual spesifik, saya bisa menyesuaikan.

Deskripsi Diagram untuk Aplikasi
1. Diagram untuk Skenario Lokal (Komputer sebagai Server)
Konsep Diagram: Menunjukkan arsitektur sistem saat aplikasi dijalankan secara lokal menggunakan komputer sebagai server, dengan TV sebagai perangkat tampilan.

Elemen Diagram:

Komputer (Server Lokal): Menjalankan aplikasi Laravel 12, menyimpan database MySQL, dan menangani logika backend.
TV: Mengakses aplikasi melalui browser (misalnya, Chrome) dengan URL lokal (contoh: http://192.168.x.x).
Admin (Perangkat Pengelola): PC/laptop untuk mengelola konten melalui antarmuka admin.
Jaringan Lokal (LAN): Menghubungkan komputer server, TV, dan perangkat admin melalui Wi-Fi/Ethernet.
Database (MySQL): Berjalan di komputer server, menyimpan data seperti jadwal sholat, pengumuman, dan keuangan.
Alur Data:
Admin mengelola konten (jadwal sholat, pengumuman, keuangan) melalui browser.
Komputer server memproses permintaan dan mengirimkan tampilan dinamis ke TV via LAN.
TV menampilkan informasi real-time (jadwal sholat, running text, kaligrafi).
Desain Visual:

Ikon persegi untuk komputer (label: "Server Lokal - Laravel 12 + MySQL").
Ikon TV dengan layar menampilkan jam, running text, dan kaligrafi.
Ikon laptop untuk admin.
Panah berlabel "HTTP Request" (TV/admin ke server) dan "Data Response" (server ke TV).
Warna biru (#0a4d68) dan hijau (#00a86b) sesuai tema aplikasi.
Latar belakang masjid/kaligrafi Islami untuk estetika.
2. Diagram untuk Skenario Hosting/Online
Konsep Diagram: Menggambarkan arsitektur sistem saat aplikasi di-host di server cloud, diakses melalui internet.

Elemen Diagram:

Cloud Server: Menjalankan Laravel 12 dan MySQL (misalnya, AWS, Google Cloud).
TV: Mengakses aplikasi via browser dengan URL publik (contoh: http://masjidanda.tv).
Admin (Perangkat Pengelola): Mengakses antarmuka admin via browser dari mana saja.
Internet: Menghubungkan TV, admin, dan cloud server.
Database (MySQL): Dihost di cloud, menyimpan semua data aplikasi.
Alur Data:
Admin mengelola konten via internet.
Cloud server memproses permintaan dan mengirimkan tampilan dinamis ke TV.
TV menampilkan informasi real-time (jadwal sholat, pengumuman, keuangan).
Keamanan: Ikon kunci untuk verifikasi dua faktor dan proteksi cyber.
Desain Visual:

Ikon awan untuk cloud server (label: "Cloud Server - Laravel 12 + MySQL").
Ikon TV dengan tampilan serupa (jam, running text, kaligrafi).
Ikon laptop untuk admin, panah ke cloud server.
Garis putus-putus untuk koneksi internet.
Ikon kunci/perisai untuk keamanan.
Warna biru, hijau, dan aksen emas untuk kaligrafi.
Latar belakang motif Islami.
Contoh Struktur Diagram (Teks)
Skenario Lokal:

text

Ciutkan

Wrap

Salin
[Admin Laptop] --> [LAN] --> [Komputer Server: Laravel 12 + MySQL]
|
|
[TV: Browser]
Skenario Hosting/Online:

text

Ciutkan

Wrap

Salin
[Admin Laptop] --> [Internet] --> [Cloud Server: Laravel 12 + MySQL]
|
|
[TV: Browser]
Jika Menginginkan Visualisasi dengan Chart.js
Jika Anda menginginkan representasi sederhana dengan Chart.js (meskipun lebih cocok untuk grafik, bukan diagram alur), saya bisa membuat diagram alur sederhana sebagai scatter plot untuk menunjukkan hubungan antar komponen. Namun, karena Chart.js tidak ideal untuk diagram alur, saya sarankan menggunakan alat seperti Mermaid.js untuk diagram yang lebih sesuai. Berikut contoh kode Mermaid.js untuk diagram alur lokal:

HTTP Request

Data Response

Admin Laptop

LAN

Komputer Server: Laravel 12 + MySQL

TV: Browser



Untuk hosting/online:

HTTP Request

Data Response

Admin Laptop

Internet

Cloud Server: Laravel 12 + MySQL

TV: Browser



Konfirmasi: Apakah Anda ingin saya menghasilkan kode visual (misalnya, Mermaid.js) untuk ditampilkan di platform yang mendukung, atau lebih suka file gambar (harus dibuat di alat eksternal seperti Canva)? Silakan beri tahu preferensi Anda!

===========
Deskripsi Gambar Realistis untuk Kedua Skenario
1. Gambar untuk Skenario Lokal (Komputer sebagai Server)
Konsep Visual: Gambar realistis yang menunjukkan pengaturan fisik di masjid, dengan komputer sebagai server lokal, TV menampilkan informasi masjid, dan laptop admin, semuanya terhubung melalui jaringan lokal (LAN).

Elemen Gambar:

Latar Belakang: Interior masjid modern dengan karpet hijau, mihrab dengan kaligrafi Islami, dan pencahayaan hangat. Tambahkan pola geometris Islami (warna biru #0a4d68) di tepi gambar.
TV: TV layar datar besar yang dipasang di dinding masjid, menampilkan antarmuka aplikasi (jadwal sholat, running text dengan pengumuman, dan animasi kaligrafi). Layar TV menunjukkan elemen seperti:
Jam digital dengan waktu sholat (misalnya, "Dzuhur: 12:00").
Running text: "Jumatan besok pukul 12:30, Imam: Ust. Ali".
Kaligrafi Islami bergerak dengan warna emas (#FFD700).
Komputer Server: Komputer desktop di ruang kantor masjid (misalnya, meja dengan monitor, CPU, dan keyboard). Tambahkan logo Laravel dan MySQL di dekatnya untuk menunjukkan teknologi yang digunakan.
Laptop Admin: Laptop terbuka di meja, menampilkan antarmuka admin aplikasi (misalnya, dashboard dengan menu "Jadwal Sholat", "Pengumuman", "Keuangan"). Gunakan ikon browser untuk menunjukkan akses via URL lokal (contoh: http://192.168.x.x).
Jaringan Lokal (LAN): Kabel Ethernet atau router Wi-Fi di latar belakang, dengan panah animasi (putih dengan efek neon) yang menghubungkan komputer server ke TV dan laptop admin. Label panah: "HTTP Request" (ke server) dan "Data Response" (ke TV).
Detail Estetika:
Gunakan palet warna biru (#0a4d68) untuk bingkai TV dan laptop, hijau (#00a86b) untuk karpet dan aksen jaringan, serta emas (#FFD700) untuk kaligrafi dan detail dekoratif.
Tambahkan bayangan lembut pada perangkat untuk efek 3D realistis.
Sertakan ikon kecil seperti logo masjid atau pola Islami di sudut gambar.
Komposisi:

TV di tengah sebagai fokus utama, dengan layar besar menampilkan antarmuka aplikasi.
Komputer server di sisi kiri, laptop admin di sisi kanan, dihubungkan oleh panah jaringan.
Latar belakang masjid di bagian bawah, dengan pola kaligrafi di bagian atas untuk bingkai.
2. Gambar untuk Skenario Hosting/Online (Cloud Server)
Konsep Visual: Gambar realistis yang menunjukkan TV di masjid dan laptop admin mengakses aplikasi melalui internet, dengan server cloud diwakili secara simbolis.

Elemen Gambar:

Latar Belakang: Interior masjid serupa (karpet hijau, mihrab dengan kaligrafi), tetapi dengan elemen awan digital di bagian atas untuk menunjukkan koneksi cloud. Gunakan gradien biru (#0a4d68) ke hijau (#00a86b).
TV: TV layar datar di dinding masjid, menampilkan antarmuka aplikasi yang sama (jadwal sholat, running text, kaligrafi). Layar menunjukkan URL publik (misalnya, http://masjidanda.tv) di sudut.
Cloud Server: Gambar simbolis server cloud (misalnya, ikon server dengan efek awan 3D) di bagian atas gambar, dengan logo Laravel dan MySQL. Tambahkan ikon kunci atau perisai (warna emas #FFD700) untuk menunjukkan fitur keamanan seperti verifikasi dua faktor.
Laptop Admin: Laptop terbuka, menampilkan antarmuka admin (dashboard serupa). Tambahkan ikon browser dengan URL publik.
Internet: Diwakili oleh ikon globe atau gelombang Wi-Fi di tengah gambar, dengan panah putus-putus (putih dengan efek neon) menghubungkan laptop admin dan TV ke cloud server. Label panah: "HTTP Request" (ke server) dan "Data Response" (ke TV).
Detail Estetika:
Warna biru (#0a4d68) untuk TV dan laptop, hijau (#00a86b) untuk aksen internet, dan emas (#FFD700) untuk kaligrafi serta ikon keamanan.
Efek 3D pada TV, laptop, dan ikon cloud untuk realisme.
Pola Islami di tepi gambar, dengan siluet masjid di latar belakang.
Komposisi:

TV di tengah sebagai fokus, dengan cloud server di atasnya.
Laptop admin di sisi kiri atau kanan, dihubungkan ke cloud server via panah putus-putus.
Latar belakang masjid di bawah, dengan elemen awan digital di atas untuk menunjukkan hosting online.