<?php

namespace App\Exports;

use App\Models\Patient;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class PatientsExport implements FromCollection, WithHeadings, WithMapping
{
	public function collection()
	{
		return Patient::all();
	}

	public function headings(): array
	{
		return [
			'No',
			'Nama Pasien',
			'Jenis Kelamin',
			'Usia',
			'Alamat',
			'Telepon',
			'Tanggal Dibuat'
		];
	}

	public function map($patient): array
	{
		return [
			$patient->id,
			$patient->name,
			$patient->gender == 'male' ? 'Laki-laki' : 'Perempuan',
			$patient->age,
			$patient->address,
			$patient->phone,
			$patient->created_at->format('d/m/Y H:i')
		];
	}
}