<?php

namespace App\Http\Controllers;

use App\Models\AppSetting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class AppSettingController extends Controller
{
    public function show()
    {
        $setting = AppSetting::first();

        if (!$setting) {
            $setting = AppSetting::create([
                'nama_aplikasi' => 'Masjid Al-Ikhlas',
                'footer' => 'Hak Cipta © <a href="https://wa.me/628179851011" target="_blank">Ali Mochtar Development System</a> ' . now()->year,
                'running_text' => 'Selamat datang di Masjid Al-Ikhlas',
            ]);
        }

        return view('about', compact('setting'));
    }

    public function edit()
    {
        $setting = AppSetting::first();

        if (!$setting) {
            $setting = AppSetting::create([
                'nama_aplikasi' => 'Deteksi Penyakit Jantung',
                'footer' => 'Hak Cipta © <a href="https://wa.me/628179851011" target="_blank">Ali Mochtar Development System</a> ' . now()->year,
                'running_text' => 'Selamat datang di Masjid Al-Ikhlas',
            ]);
        }

        return view('settings.edit', compact('setting'));
    }

    public function update(Request $request)
    {
        $request->validate([
            'nama_aplikasi' => 'required|string|max:255',
            'favicon' => 'nullable|image|mimes:jpeg,png,jpg,gif,ico|max:2048',
            'background' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:5120',
            'logo' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'footer' => 'nullable|string',
            'running_text' => 'nullable|string',
        ]);

        $setting = AppSetting::first();

        if (!$setting) {
            $setting = new AppSetting();
        }

        $setting->nama_aplikasi = $request->nama_aplikasi;
        $setting->footer = $request->footer;
        $setting->running_text = $request->running_text;

        // Handle file uploads
        $this->handleFileUpload($request, 'favicon', $setting);
        $this->handleFileUpload($request, 'background', $setting);
        $this->handleFileUpload($request, 'logo', $setting);

        $setting->save();

        return redirect()->route('settings.edit')
        ->with('success', 'Pengaturan aplikasi berhasil diperbarui!');
    }

    protected function handleFileUpload($request, $fieldName, $setting)
    {
        if ($request->hasFile($fieldName)) {
            // Hapus file lama jika ada
            if ($setting->$fieldName && Storage::exists('public/' . $setting->$fieldName)) {
                Storage::delete('public/' . $setting->$fieldName);
            }

            // Simpan file baru
            $path = $request->file($fieldName)->store('settings', 'public');
            $setting->$fieldName = $path;
        }
    }
}
