<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Role;
use App\Models\AppSetting;
use Illuminate\Http\Request;

class UserController extends Controller
{
    public function index()
    {
           $users = User::with('role')->orderBy('name')->get();  // Mengambil users beserta role-nya


        // Ambil setting
           $setting = AppSetting::first();

        // Jika belum ada, buat default
           if (!$setting) {
            $setting = AppSetting::create([
                'nama_aplikasi' => 'Masjid Al-Ikhlas',
                'footer' => 'Copyright &copy; <a href="https://wa.me/628179851011" target="_blank">Ali Mochtar Development System</a> ' . date('Y')
            ]);
        }

        return view('users.index', compact('users', 'setting'));
    }
    public function create()
    {
        $roles = Role::all();
        $setting = AppSetting::firstOrCreate([
            'nama_aplikasi' => 'Masjid Al-Ikhlas',
            'footer' => 'Copyright &copy; <a href="https://wa.me/628179851011" target="_blank">Ali Mochtar Development System</a> ' . date('Y')
        ]);

        return view('users.create', compact('roles', 'setting'));
    }

    public function edit(User $user)
    {
    $roles = Role::all(); // Ambil daftar role untuk form edit
    $setting = AppSetting::first();
    if (!$setting) {
        $setting = AppSetting::create([
            'nama_aplikasi' => 'Masjid Al-Ikhlas',
            'footer' => 'Copyright &copy; <a href="https://wa.me/628179851011" target="_blank">Ali Mochtar Development System</a> ' . date('Y')
        ]);
    }

    return view('users.edit', compact('user', 'roles', 'setting')); // Pass roles
}


public function store(Request $request)
{
    $request->validate([
        'name' => 'required|string|max:255',
        'last_name' => 'nullable|string|max:255',
        'email' => 'required|email|unique:users,email',
        'role_id' => 'required|exists:roles,id', // Gunakan role_id untuk referensi
        'password' => 'required|confirmed|min:6',
    ]);

    User::create([
        'name' => $request->name,
        'last_name' => $request->last_name,
        'email' => $request->email,
        'role_id' => $request->role_id, // Simpan role_id
        'password' => $request->password, // akan otomatis dihash oleh mutator
    ]);

    return redirect()->route('users.index')->with('success', 'Akun berhasil ditambahkan.');
}


public function update(Request $request, User $user)
{
    $request->validate([
        'name' => 'required|string|max:255',
        'last_name' => 'nullable|string|max:255',
        'email' => 'required|email|unique:users,email,' . $user->id,
        'role_id' => 'required|exists:roles,id', // Gunakan role_id untuk referensi
        'password' => 'nullable|confirmed|min:6',
    ]);

    $data = $request->only(['name', 'last_name', 'email', 'role_id']); // Perbarui role_id

    if ($request->filled('password')) {
        $data['password'] = $request->password; // otomatis dihash
    }

    $user->update($data);

    return redirect()->route('users.index')->with('success', 'Akun berhasil diperbarui.');
}


public function destroy(User $user)
{
    $user->delete();
    return redirect()->route('users.index')->with('success', 'Akun berhasil dihapus.');
}
}
