@extends('layouts.auth')

@section('main-content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-xl-10 col-lg-12 col-md-9">
            <div class="card o-hidden border-0 shadow-lg my-5">
                <div class="card-body p-0">
                    <div class="row">
                        <!-- Dynamic Login Background Column -->
                        <div class="col-lg-6 d-none d-lg-block" style="
                        @if(isset($setting['background']))
                        background: url('{{ asset('storage/' . $setting['background']) }}');
    @else
    background: url('{{ asset('img/login-bg.jpg') }}');
    @endif
    background-size: cover;
    background-position: center;
    "></div>
    
    <div class="col-lg-6">
        <div class="p-5">
            <div class="text-center">
                <!-- Dynamic Logo -->
                <img src="{{ isset($setting['logo']) ? asset('storage/' . $setting['logo']) : asset('img/logo.png') }}" 
                alt="Logo" 
                class="img-fluid mb-3" 
                width="80">
                <h2 class="h4 text-gray-900 mb-4">{{ $setting['nama_aplikasi'] ?? config('app.name', 'Laravel') }}</h2>
            </div>

            @if ($errors->any())
            <div class="alert alert-danger border-left-danger" role="alert">
                <ul class="pl-4 my-2">
                    @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
            @endif

            <form method="POST" action="{{ route('login') }}" class="user">
                @csrf

                <div class="form-group">
                    <input type="email" class="form-control form-control-user" name="email" placeholder="{{ __('E-Mail Address') }}" value="{{ old('email') }}" required autofocus>
                </div>

                <div class="form-group">
                    <input type="password" class="form-control form-control-user" name="password" placeholder="{{ __('Password') }}" required>
                </div>

                <div class="form-group">
                    <div class="custom-control custom-checkbox small">
                        <input type="checkbox" class="custom-control-input" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
                        <label class="custom-control-label" for="remember">{{ __('Remember Me') }}</label>
                    </div>
                </div>

                <div class="form-group">
                    <button type="submit" class="btn btn-primary btn-user btn-block">
                        {{ __('Login') }}
                    </button>
                </div>
            </form>

            <hr>

            @if (Route::has('password.request'))
            <div class="text-center">
                <a class="small" href="{{ route('password.request') }}">
                    {{ __('Lupa Kata Sandi?') }}
                </a>
            </div>
            @endif
            <div class="text-center">
                <a class="small" href="{{ url('/') }}">
                    ← Kembali ke Beranda
                </a>
            </div>
            
            <!-- Dynamic Footer -->
            <center>
                @if(isset($setting['footer']))
                {!! $setting['footer'] !!}
                @else
                <a href="https://wa.me/628179851011" target="_blank" style="font-size: 12px; text-decoration: none; color: gray;">
                    Copyright &copy; {{ now()->year }} Ali Mochtar Development System
                </a>
                @endif
            </center>
        </div>
    </div>
</div>
</div>
</div>
</div>
</div>
</div>
@endsection