<!-- resources/views/home.blade.php -->
@extends('layouts.admin')

@section('main-content')
<!-- Page Heading -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0 text-gray-800">{{ __('Dashboard') }}</h1>
    <div class="text-muted small">Selamat datang, {{ auth()->user()->name }}</div>
</div>

<!-- Notification Alerts -->
@if (session('success'))
<div class="alert alert-success border-left-success alert-dismissible fade show" role="alert">
    <i class="fas fa-check-circle mr-2"></i>
    {{ session('success') }}
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
        <span aria-hidden="true">&times;</span>
    </button>
</div>
@endif

@if (session('status'))
<div class="alert alert-success border-left-success alert-dismissible fade show" role="alert">
    <i class="fas fa-check-circle mr-2"></i>
    {{ session('status') }}
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
        <span aria-hidden="true">&times;</span>
    </button>
</div>
@endif

@if (session('welcome'))
<div class="alert alert-info border-left-info alert-dismissible fade show" role="alert">
    <i class="fas fa-info-circle mr-2"></i>
    {{ session('welcome') }}
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
        <span aria-hidden="true">&times;</span>
    </button>
</div>
@endif

<div class="row">
    @if (auth()->user()->role && auth()->user()->role->name === 'admin')
    <!-- Admin Dashboard Cards -->
    <div class="col-xl-3 col-md-6 mb-4">
        <a href="{{ route('users.index') }}" class="card-link">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Total Pengguna</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $widget['users'] ?? 0 }}</div>
                            <div class="mt-2 text-xs text-muted">Kelola akun pengguna</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-users fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </a>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <a href="{{ route('keuangan.index') }}" class="card-link">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Keuangan Masjid</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                @php
                                $totalPemasukan = \App\Models\Keuangan::sum('pemasukan');
                                $totalPengeluaran = \App\Models\Keuangan::sum('pengeluaran');
                                $saldo = $totalPemasukan - $totalPengeluaran;
                                echo 'Rp ' . number_format($saldo, 0, ',', '.');
                                @endphp
                            </div>
                            <div class="mt-2 text-xs text-muted">Saldo terkini</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-wallet fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </a>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <a href="{{ route('jadwal_sholat.index') }}" class="card-link">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Jadwal Sholat</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{\App\Models\JadwalSholat::count()}} Jadwal
                            </div>
                            <div class="mt-2 text-xs text-muted">Atur waktu sholat</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clock fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </a>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <a href="{{ route('sholat_jumat.index') }}" class="card-link">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Sholat Jumat</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{\App\Models\SholatJumat::where('tanggal', '>=', now())->count()}} Jadwal
                            </div>
                            <div class="mt-2 text-xs text-muted">Atur petugas Jumat</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-mosque fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </a>
    </div>

    <!-- Additional Admin Cards -->
    <div class="col-xl-3 col-md-6 mb-4">
        <a href="{{ route('pengumuman.index') }}" class="card-link">
            <div class="card border-left-purple shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-purple text-uppercase mb-1">Pengumuman</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{\App\Models\Pengumuman::count()}} Active
                            </div>
                            <div class="mt-2 text-xs text-muted">Informasi jamaah</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-bullhorn fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </a>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <a href="{{ route('settings.edit') }}" class="card-link">
            <div class="card border-left-secondary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-secondary text-uppercase mb-1">Pengaturan</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">Aplikasi</div>
                            <div class="mt-2 text-xs text-muted">Konfigurasi sistem</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-cogs fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </a>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <a href="{{ route('about') }}" class="card-link">
            <div class="card border-left-dark shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-dark text-uppercase mb-1">Tentang</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">Aplikasi</div>
                            <div class="mt-2 text-xs text-muted">Informasi sistem</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-info-circle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </a>
    </div>

    <!-- Recent Activities Section -->


    @elseif (auth()->user()->role && auth()->user()->role->name === 'karyawan')
<!-- Karyawan Dashboard Cards -->
<div class="col-xl-4 col-md-6 mb-4">
    <a href="{{ route('profile') }}" class="card-link">
        <div class="card border-left-primary shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Profil Saya</div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ auth()->user()->name }}</div>
                        <div class="mt-2 text-xs text-muted">Kelola profil Anda</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-user fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </a>
</div>

<div class="col-xl-4 col-md-6 mb-4">
    <a href="{{ route('sholat_jumat.index') }}" class="card-link">
        <div class="card border-left-warning shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Jadwal Jumat</div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                            {{\App\Models\SholatJumat::where('tanggal', '>=', now())->count()}} Mendatang
                        </div>
                        <div class="mt-2 text-xs text-muted">Lihat jadwal Anda</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-mosque fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </a>
</div>

<div class="col-xl-4 col-md-6 mb-4">
    <a href="{{ route('about') }}" class="card-link">
        <div class="card border-left-info shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Tentang</div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">Aplikasi</div>
                        <div class="mt-2 text-xs text-muted">Informasi sistem</div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-info-circle fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </a>
</div>

<!-- Jadwal Sholat Hari Ini -->
<div class="col-lg-12 mb-4">
    <div class="card shadow">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">Jadwal Sholat Hari Ini</h6>
            <div class="text-muted small">{{ now()->format('l, d F Y') }}</div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover">
                    <thead class="thead-light">
                        <tr>
                            <th>Sholat</th>
                            <th>Waktu</th>
                            <th>Waktu Tersisa</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                        $todaySchedules = \App\Models\JadwalSholat::whereDate('created_at', now())->get();
                        @endphp

                        @if($todaySchedules->count() > 0)
                        @foreach($todaySchedules as $schedule)
                        <tr>
                            <td>{{ $schedule->nama_sholat }}</td>
                            <td>{{ $schedule->waktu }}</td>
                            <td>
                                @php
                                $timeLeft = \Carbon\Carbon::parse($schedule->waktu)->diffForHumans();
                                echo $timeLeft;
                                @endphp
                            </td>
                        </tr>
                        @endforeach
                        @else
                        <tr>
                            <td colspan="3" class="text-center">Tidak ada jadwal untuk hari ini</td>
                        </tr>
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endif
</div>

<!-- Custom CSS -->
<style>
    .card-link {
        text-decoration: none;
        transition: transform 0.3s ease;
    }
    
    .card-link:hover {
        transform: translateY(-5px);
    }
    
    .card {
        border-radius: 10px;
        transition: all 0.3s ease;
    }
    
    .card:hover {
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }
    
    .border-left-primary {
        border-left: 4px solid #4e73df;
    }
    
    .border-left-success {
        border-left: 4px solid #1cc88a;
    }
    
    .border-left-info {
        border-left: 4px solid #36b9cc;
    }
    
    .border-left-warning {
        border-left: 4px solid #f6c23e;
    }
    
    .border-left-purple {
        border-left: 4px solid #6f42c1;
    }
    
    .border-left-secondary {
        border-left: 4px solid #858796;
    }
    
    .border-left-dark {
        border-left: 4px solid #5a5c69;
    }
    
    .activity-feed .feed-item {
        padding: 10px;
        border-left: 3px solid #4e73df;
        background-color: #f8f9fc;
        margin-bottom: 5px;
        border-radius: 0 5px 5px 0;
    }
    
    .table-hover tbody tr:hover {
        background-color: rgba(78, 115, 223, 0.05);
    }
</style>
@endsection