@extends('layouts.admin')

@section('main-content')
<h1 class="h3 mb-4 text-gray-800">Kelola Jadwal Sholat</h1>
<a href="{{ route('jadwal_sholat.create') }}" class="btn btn-primary mb-3">Tambah Jadwal Sholat</a>
<div class="card shadow mb-4">
	<div class="card-body">
		<table class="table table-bordered">
			<thead>
				<tr>
					<th>Nama Sholat</th>
					<th>Waktu</th>
					<th>Aksi</th>
				</tr>
			</thead>
			<tbody>
				@foreach ($jadwal as $item)
				<tr>
					<td>{{ $item->nama_sholat }}</td>
					<td>{{ $item->waktu }}</td>
					<td>
						<a href="{{ route('jadwal_sholat.edit', $item) }}" class="btn btn-sm btn-warning">Ubah</a>
						<form action="{{ route('jadwal_sholat.destroy', $item) }}" method="POST" style="display:inline;">
							@csrf
							@method('DELETE')
							<button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Yakin ingin menghapus?')">Hapus</button>
						</form>
					</td>
				</tr>
				@endforeach
			</tbody>
		</table>
	</div>
</div>
@endsection
