<!-- resources/views/keuangan/create.blade.php -->
@extends('layouts.admin')

@section('main-content')
<div class="container-fluid">
	<div class="d-sm-flex align-items-center justify-content-between mb-4">
		<h1 class="h3 mb-0 text-gray-800">Tambah Transaksi Keuangan</h1>
	</div>

	@if ($errors->any())
	<div class="alert alert-danger">
		<ul class="mb-0">
			@foreach ($errors->all() as $error)
			<li>{{ $error }}</li>
			@endforeach
		</ul>
	</div>
	@endif

	<div class="card shadow mb-4">
		<div class="card-header py-3">
			<h6 class="m-0 font-weight-bold text-primary">Form Transaksi</h6>
		</div>
		<div class="card-body">
			<form action="{{ route('keuangan.store') }}" method="POST">
				@csrf
				<div class="form-group">
					<label for="tanggal">Tanggal</label>
					<input type="date" class="form-control" id="tanggal" name="tanggal" value="{{ old('tanggal') }}" required>
				</div>
				<div class="form-group">
					<label for="deskripsi">Deskripsi</label>
					<input type="text" class="form-control" id="deskripsi" name="deskripsi" value="{{ old('deskripsi') }}" required>
				</div>
				<div class="form-group">
					<label for="kategori">Kategori</label>
					<select class="form-control" id="kategori" name="kategori">
						<option value="" {{ old('kategori') == '' ? 'selected' : '' }}>-</option>
						<option value="Sumbangan" {{ old('kategori') == 'Sumbangan' ? 'selected' : '' }}>Sumbangan</option>
						<option value="Operasional" {{ old('kategori') == 'Operasional' ? 'selected' : '' }}>Operasional</option>
						<option value="Konsumsi" {{ old('kategori') == 'Konsumsi' ? 'selected' : '' }}>Konsumsi</option>
						<option value="Perawatan" {{ old('kategori') == 'Perawatan' ? 'selected' : '' }}>Perawatan</option>
						<option value="Iuran" {{ old('kategori') == 'Iuran' ? 'selected' : '' }}>Iuran</option>
						<option value="Inventaris" {{ old('kategori') == 'Inventaris' ? 'selected' : '' }}>Inventaris</option>
						<option value="Pembangunan" {{ old('kategori') == 'Pembangunan' ? 'selected' : '' }}>Pembangunan</option>
					</select>
				</div>
				<div class="form-group">
					<label for="pemasukan">Pemasukan (Rp)</label>
					<input type="number" class="form-control" id="pemasukan" name="pemasukan" step="0.01" value="{{ old('pemasukan') }}">
				</div>
				<div class="form-group">
					<label for="pengeluaran">Pengeluaran (Rp)</label>
					<input type="number" class="form-control" id="pengeluaran" name="pengeluaran" step="0.01" value="{{ old('pengeluaran') }}">
				</div>
				<button type="submit" class="btn btn-primary">Simpan</button>
				<a href="{{ route('keuangan.index') }}" class="btn btn-secondary">Batal</a>
			</form>
		</div>
	</div>
</div>
@endsection