<!-- resources/views/keuangan/index.blade.php -->
@extends('layouts.admin')

@section('main-content')
<div class="container-fluid">
	<div class="d-sm-flex align-items-center justify-content-between mb-4">
		<h1 class="h3 mb-0 text-gray-800">Kelola Keuangan</h1>
		<a href="{{ route('keuangan.create') }}" class="btn btn-primary">Tambah Transaksi</a>
	</div>

	@if (session('success'))
	<div class="alert alert-success alert-dismissible fade show" role="alert">
		{{ session('success') }}
		<button type="button" class="close" data-dismiss="alert" aria-label="Close">
			<span aria-hidden="true">&times;</span>
		</button>
	</div>
	@endif

	@if ($errors->any())
	<div class="alert alert-danger">
		<ul class="mb-0">
			@foreach ($errors->all() as $error)
			<li>{{ $error }}</li>
			@endforeach
		</ul>
	</div>
	@endif

	<div class="card shadow mb-4">
		<div class="card-header py-3">
			<h6 class="m-0 font-weight-bold text-primary">Ringkasan Keuangan</h6>
		</div>
		<div class="card-body">
			<div class="row">
				<div class="col-md-4">
					<p><strong>Total Pemasukan:</strong> Rp {{ number_format($totalPemasukan, 2, ',', '.') }}</p>
				</div>
				<div class="col-md-4">
					<p><strong>Total Pengeluaran:</strong> Rp {{ number_format($totalPengeluaran, 2, ',', '.') }}</p>
				</div>
				<div class="col-md-4">
					<p><strong>Saldo:</strong> Rp {{ number_format($saldo, 2, ',', '.') }}</p>
				</div>
			</div>
		</div>
	</div>

	<div class="card shadow mb-4">
		<div class="card-header py-3">
			<h6 class="m-0 font-weight-bold text-primary">Daftar Transaksi</h6>
		</div>
		<div class="card-body">
			<div class="table-responsive">
				<table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
					<thead>
						<tr>
							<th>Tanggal</th>
							<th>Deskripsi</th>
							<th>Kategori</th>
							<th>Pemasukan</th>
							<th>Pengeluaran</th>
							<th>Saldo</th>
							<th>Aksi</th>
						</tr>
					</thead>
					<tbody>
						@foreach ($keuangan as $item)
						<tr>
							<td>{{ \Carbon\Carbon::parse($item->tanggal)->translatedFormat('d F Y') }}</td>
							<td>{{ $item->deskripsi }}</td>
							<td>{{ $item->kategori ?? '-' }}</td>
							<td>Rp {{ number_format($item->pemasukan, 2, ',', '.') }}</td>
							<td>Rp {{ number_format($item->pengeluaran, 2, ',', '.') }}</td>
							<td>Rp {{ number_format($item->saldo, 2, ',', '.') }}</td>
							<td>
								<a href="{{ route('keuangan.edit', $item) }}" class="btn btn-sm btn-warning">Ubah</a>
								<form action="{{ route('keuangan.destroy', $item) }}" method="POST" style="display:inline;">
									@csrf
									@method('DELETE')
									<button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Yakin ingin menghapus?')">Hapus</button>
								</form>
							</td>
						</tr>
						@endforeach
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
@endsection
