
@extends('layouts.admin')

@section('main-content')
<h1 class="h3 mb-4 text-gray-800">Ubah Pengumuman</h1>
<div class="card shadow mb-4">
	<div class="card-body">
		<form action="{{ route('pengumuman.update', $pengumuman) }}" method="POST">
			@csrf
			@method('PUT')
			<div class="form-group">
				<label>Isi Pengumuman</label>
				<textarea name="isi" class="form-control" required>{{ $pengumuman->isi }}</textarea>
			</div>
			<div class="form-group">
				<label>Tanggal</label>
				<input type="date" name="tanggal" class="form-control" value="{{ $pengumuman->tanggal }}" required>
			</div>
			<button type="submit" class="btn btn-primary">Simpan</button>
			<a href="{{ route('pengumuman.index') }}" class="btn btn-secondary">Batal</a>
		</form>
	</div>
</div>
@endsection
