@extends('layouts.admin')

@section('main-content')
<h1 class="h3 mb-4 text-gray-800">Kelola Pengumuman</h1>
<a href="{{ route('pengumuman.create') }}" class="btn btn-primary mb-3">Tambah Pengumuman</a>
<div class="card shadow mb-4">
	<div class="card-body">
		<table class="table table-bordered">
			<thead>
				<tr>
					<th>Isi Pengumuman</th>
					<th>Tanggal</th>
					<th>Aksi</th>
				</tr>
			</thead>
			<tbody>
				@foreach ($pengumuman as $item)
				<tr>
					<td>{{ $item->isi }}</td>
					<td>{{ $item->tanggal ? \Carbon\Carbon::parse($item->tanggal)->translatedFormat('d F Y') : '-' }}</td>
					<td>
						<a href="{{ route('pengumuman.edit', $item) }}" class="btn btn-sm btn-warning">Ubah</a>
						<form action="{{ route('pengumuman.destroy', $item) }}" method="POST" style="display:inline;">
							@csrf
							@method('DELETE')
							<button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Yakin ingin menghapus?')">Hapus</button>
						</form>
					</td>
				</tr>
				@endforeach
			</tbody>
		</table>
	</div>
</div>
@endsection
