@extends('layouts.admin')

@section('main-content')
<h1 class="h3 mb-4 text-gray-800">Kelola Sholat Jumat</h1>
<a href="{{ route('sholat_jumat.create') }}" class="btn btn-primary mb-3">Tambah Sholat Jumat</a>
<div class="card shadow mb-4">
	<div class="card-body">
		<table class="table table-bordered">
			<thead>
				<tr>
					<th>Tanggal</th>
					<th>Imam</th>
					<th>Khatib</th>
					<th>Muadzin</th>
					<th>Aksi</th>
				</tr>
			</thead>
			<tbody>
				@foreach ($sholatJumat as $item)
				<tr>
					<td>{{ $item->tanggal }}</td>
					<td>{{ $item->imam ?? '-' }}</td>
					<td>{{ $item->khatib ?? '-' }}</td>
					<td>{{ $item->muadzin ?? '-' }}</td>
					<td>
						<a href="{{ route('sholat_jumat.edit', $item) }}" class="btn btn-sm btn-warning">Ubah</a>
						<form action="{{ route('sholat_jumat.destroy', $item) }}" method="POST" style="display:inline;">
							@csrf
							@method('DELETE')
							<button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Yakin ingin menghapus?')">Hapus</button>
						</form>
					</td>
				</tr>
				@endforeach
			</tbody>
		</table>
	</div>
</div>
@endsection
