@extends('layouts.admin')

@section('main-content')
<div class="container-fluid">
	<h1 class="h3 mb-4 text-gray-800">Edit Akun</h1>

	<div class="card shadow">
		<div class="card-body">
			<form action="{{ route('users.update', $user->id) }}" method="POST">
				@csrf
				@method('PUT')

				<div class="form-group">
					<label for="name">Nama Depan</label>
					<input type="text" name="name" class="form-control" value="{{ old('name', $user->name) }}" required>
				</div>

				<div class="form-group">
					<label for="last_name">Nama Belakang</label>
					<input type="text" name="last_name" class="form-control" value="{{ old('last_name', $user->last_name) }}">
				</div>

				<div class="form-group">
					<label for="email">Email</label>
					<input type="email" name="email" class="form-control" value="{{ old('email', $user->email) }}" required>
				</div>

				<div class="form-group">
					<label for="role_id">Role</label>
					<select name="role_id" class="form-control" required>
						@foreach($roles as $role)
						<option value="{{ $role->id }}" {{ $user->role_id == $role->id ? 'selected' : '' }}>
							{{ ucfirst($role->name) }}
						</option>
						@endforeach
					</select>
				</div>

				<div class="form-group">
					<label for="password">Password (Kosongkan jika tidak diubah)</label>
					<input type="password" name="password" class="form-control">
				</div>

				<div class="form-group">
					<label for="password_confirmation">Konfirmasi Password</label>
					<input type="password" name="password_confirmation" class="form-control">
				</div>

				<button type="submit" class="btn btn-success">Update</button>
				<a href="{{ route('users.index') }}" class="btn btn-secondary">Kembali</a>
			</form>
		</div>
	</div>
</div>
@endsection
