<!-- resources/views/users/index.blade.php -->
@extends('layouts.admin')

@section('main-content')
<div class="container">
	<h1>Kelola Akun</h1>
	<a href="{{ route('users.create') }}" class="btn btn-primary mb-3">Tambah Akun</a>
	@if (session('success'))
	<div class="alert alert-success">{{ session('success') }}</div>
	@endif
	<table class="table table-bordered">
		<thead>
			<tr>
				<th>Nama Lengkap</th>
				<th>Email</th>
				<th>Role</th> <!-- Menampilkan Role -->
				<th>Aksi</th>
			</tr>
		</thead>
		<tbody>
			@foreach ($users as $user)
			<tr>
				<td>{{ $user->full_name }}</td>
				<td>{{ $user->email }}</td>
				<td>{{ $user->role ? $user->role->name : 'Tidak Ada Role' }}</td> <!-- Menampilkan nama role -->
				<td>
					<a href="{{ route('users.edit', $user->id) }}" class="btn btn-sm btn-warning">Edit</a>
					<form action="{{ route('users.destroy', $user->id) }}" method="POST" style="display:inline;">
						@csrf @method('DELETE')
						<button class="btn btn-sm btn-danger" onclick="return confirm('Yakin hapus akun ini?')">Hapus</button>
					</form>
				</td>
			</tr>
			@endforeach
		</tbody>
	</table>
</div>
@endsection
