<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\AppSettingController;
use App\Http\Controllers\JadwalSholatController;
use App\Http\Controllers\SholatJumatController;
use App\Http\Controllers\PengumumanController;
use App\Http\Controllers\KeuanganController;
use App\Http\Controllers\WelcomeController;

Route::get('/', [WelcomeController::class, 'index'])->name('welcome');

Route::get('/utama', function () {
    $settings = \App\Models\AppSetting::first();
    $jadwalSholat = \App\Models\JadwalSholat::all();
    return view('utama', compact('settings', 'jadwalSholat'));
})->name('utama');

Route::get('/infokeuangan', function () {
    $settings = \App\Models\AppSetting::first();
    $keuangan = \App\Models\Keuangan::orderBy('tanggal', 'desc')->get();
    $totalPemasukan = \App\Models\Keuangan::sum('pemasukan');
    $totalPengeluaran = \App\Models\Keuangan::sum('pengeluaran');
    $saldo = $totalPemasukan - $totalPengeluaran;
    return view('keuangan', compact('settings', 'keuangan', 'totalPemasukan', 'totalPengeluaran', 'saldo'));
})->name('keuangan');

Route::get('/data-timestamp', [WelcomeController::class, 'getDataTimestamp'])->name('data.timestamp');

Auth::routes();

Route::middleware(['auth'])->group(function () {
    Route::get('/home', [HomeController::class, 'index'])->name('home');
    Route::get('/profile', [ProfileController::class, 'index'])->name('profile');
    Route::put('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::resource('users', UserController::class);
    Route::resource('roles', RoleController::class);
    Route::get('/about', [AppSettingController::class, 'show'])->name('about');
    Route::prefix('settings')->group(function () {
        Route::get('/', [AppSettingController::class, 'edit'])->name('settings.edit');
        Route::put('/', [AppSettingController::class, 'update'])->name('settings.update');
    });
    Route::resource('jadwal_sholat', JadwalSholatController::class);
    Route::resource('sholat_jumat', SholatJumatController::class);
    Route::resource('pengumuman', PengumumanController::class);
    Route::resource('keuangan', KeuanganController::class);
});