<?php $__env->startSection('main-content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-xl-10 col-lg-12 col-md-9">
            <div class="card o-hidden border-0 shadow-lg my-5">
                <div class="card-body p-0">
                    <div class="row">
                        <!-- Dynamic Login Background Column -->
                        <div class="col-lg-6 d-none d-lg-block" style="
                        <?php if(isset($setting['background'])): ?>
                        background: url('<?php echo e(asset('storage/' . $setting['background'])); ?>');
    <?php else: ?>
    background: url('<?php echo e(asset('img/login-bg.jpg')); ?>');
    <?php endif; ?>
    background-size: cover;
    background-position: center;
    "></div>
    
    <div class="col-lg-6">
        <div class="p-5">
            <div class="text-center">
                <!-- Dynamic Logo -->
                <img src="<?php echo e(isset($setting['logo']) ? asset('storage/' . $setting['logo']) : asset('img/logo.png')); ?>" 
                alt="Logo" 
                class="img-fluid mb-3" 
                width="80">
                <h2 class="h4 text-gray-900 mb-4"><?php echo e($setting['nama_aplikasi'] ?? config('app.name', 'Laravel')); ?></h2>
            </div>

            <?php if($errors->any()): ?>
            <div class="alert alert-danger border-left-danger" role="alert">
                <ul class="pl-4 my-2">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
            <?php endif; ?>

            <form method="POST" action="<?php echo e(route('login')); ?>" class="user">
                <?php echo csrf_field(); ?>

                <div class="form-group">
                    <input type="email" class="form-control form-control-user" name="email" placeholder="<?php echo e(__('E-Mail Address')); ?>" value="<?php echo e(old('email')); ?>" required autofocus>
                </div>

                <div class="form-group">
                    <input type="password" class="form-control form-control-user" name="password" placeholder="<?php echo e(__('Password')); ?>" required>
                </div>

                <div class="form-group">
                    <div class="custom-control custom-checkbox small">
                        <input type="checkbox" class="custom-control-input" name="remember" id="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>
                        <label class="custom-control-label" for="remember"><?php echo e(__('Remember Me')); ?></label>
                    </div>
                </div>

                <div class="form-group">
                    <button type="submit" class="btn btn-primary btn-user btn-block">
                        <?php echo e(__('Login')); ?>

                    </button>
                </div>
            </form>

            <hr>

            <?php if(Route::has('password.request')): ?>
            <div class="text-center">
                <a class="small" href="<?php echo e(route('password.request')); ?>">
                    <?php echo e(__('Lupa Kata Sandi?')); ?>

                </a>
            </div>
            <?php endif; ?>
            <div class="text-center">
                <a class="small" href="<?php echo e(url('/')); ?>">
                    ← Kembali ke Beranda
                </a>
            </div>
            
            <!-- Dynamic Footer -->
            <center>
                <?php if(isset($setting['footer'])): ?>
                <?php echo $setting['footer']; ?>

                <?php else: ?>
                <a href="https://wa.me/628179851011" target="_blank" style="font-size: 12px; text-decoration: none; color: gray;">
                    Copyright &copy; <?php echo e(now()->year); ?> Ali Mochtar Development System
                </a>
                <?php endif; ?>
            </center>
        </div>
    </div>
</div>
</div>
</div>
</div>
</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.auth', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\PROJECT LARAVEL\DISPLAY-INFORMASI-MASJID\resources\views/auth/login.blade.php ENDPATH**/ ?>