<!-- resources/views/keuangan/edit.blade.php -->


<?php $__env->startSection('main-content'); ?>
<div class="container-fluid">
	<div class="d-sm-flex align-items-center justify-content-between mb-4">
		<h1 class="h3 mb-0 text-gray-800">Ubah Transaksi Keuangan</h1>
	</div>

	<?php if($errors->any()): ?>
	<div class="alert alert-danger">
		<ul class="mb-0">
			<?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			<li><?php echo e($error); ?></li>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		</ul>
	</div>
	<?php endif; ?>

	<div class="card shadow mb-4">
		<div class="card-header py-3">
			<h6 class="m-0 font-weight-bold text-primary">Form Transaksi</h6>
		</div>
		<div class="card-body">
			<form action="<?php echo e(route('keuangan.update', $keuangan)); ?>" method="POST">
				<?php echo csrf_field(); ?>
				<?php echo method_field('PUT'); ?>
				<div class="form-group">
					<label for="tanggal">Tanggal</label>
					<input type="date" class="form-control" id="tanggal" name="tanggal" value="<?php echo e(old('tanggal', $keuangan->tanggal)); ?>" required>
				</div>
				<div class="form-group">
					<label for="deskripsi">Deskripsi</label>
					<input type="text" class="form-control" id="deskripsi" name="deskripsi" value="<?php echo e(old('deskripsi', $keuangan->deskripsi)); ?>" required>
				</div>
				<div class="form-group">
					<label for="kategori">Kategori</label>
					<select class="form-control" id="kategori" name="kategori">
						<option value="" <?php echo e(old('kategori', $keuangan->kategori) == '' ? 'selected' : ''); ?>>-</option>
						<option value="Sumbangan" <?php echo e(old('kategori', $keuangan->kategori) == 'Sumbangan' ? 'selected' : ''); ?>>Sumbangan</option>
						<option value="Operasional" <?php echo e(old('kategori', $keuangan->kategori) == 'Operasional' ? 'selected' : ''); ?>>Operasional</option>
						<option value="Konsumsi" <?php echo e(old('kategori', $keuangan->kategori) == 'Konsumsi' ? 'selected' : ''); ?>>Konsumsi</option>
						<option value="Perawatan" <?php echo e(old('kategori', $keuangan->kategori) == 'Perawatan' ? 'selected' : ''); ?>>Perawatan</option>
						<option value="Iuran" <?php echo e(old('kategori', $keuangan->kategori) == 'Iuran' ? 'selected' : ''); ?>>Iuran</option>
						<option value="Inventaris" <?php echo e(old('kategori', $keuangan->kategori) == 'Inventaris' ? 'selected' : ''); ?>>Inventaris</option>
						<option value="Pembangunan" <?php echo e(old('kategori', $keuangan->kategori) == 'Pembangunan' ? 'selected' : ''); ?>>Pembangunan</option>
					</select>
				</div>
				<div class="form-group">
					<label for="pemasukan">Pemasukan (Rp)</label>
					<input type="number" class="form-control" id="pemasukan" name="pemasukan" step="0.01" value="<?php echo e(old('pemasukan', $keuangan->pemasukan)); ?>">
				</div>
				<div class="form-group">
					<label for="pengeluaran">Pengeluaran (Rp)</label>
					<input type="number" class="form-control" id="pengeluaran" name="pengeluaran" step="0.01" value="<?php echo e(old('pengeluaran', $keuangan->pengeluaran)); ?>">
				</div>
				<button type="submit" class="btn btn-primary">Simpan</button>
				<a href="<?php echo e(route('keuangan.index')); ?>" class="btn btn-secondary">Batal</a>
			</form>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\PROJECT LARAVEL\DISPLAY-INFORMASI-MASJID\resources\views/keuangan/edit.blade.php ENDPATH**/ ?>