


<?php $__env->startSection('main-content'); ?>
<div class="container-fluid">
	<div class="d-sm-flex align-items-center justify-content-between mb-4">
		<h1 class="h3 mb-0 text-gray-800">Pengaturan Aplikasi</h1>
	</div>

	<?php if(session('success')): ?>
	<div class="alert alert-success alert-dismissible fade show" role="alert">
		<?php echo e(session('success')); ?>

		<button type="button" class="close" data-dismiss="alert" aria-label="Close">
			<span aria-hidden="true">×</span>
		</button>
	</div>
	<?php endif; ?>

	<?php if($errors->any()): ?>
	<div class="alert alert-danger">
		<ul class="mb-0">
			<?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			<li><?php echo e($error); ?></li>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		</ul>
	</div>
	<?php endif; ?>

	<div class="card shadow mb-4">
		<div class="card-header py-3">
			<h6 class="m-0 font-weight-bold text-primary">Form Pengaturan</h6>
		</div>
		<div class="card-body">
			<form action="<?php echo e(route('settings.update')); ?>" method="POST" enctype="multipart/form-data">
				<?php echo csrf_field(); ?>
				<?php echo method_field('PUT'); ?>

				<div class="row">
					<div class="col-md-6">
						<div class="form-group">
							<label for="nama_aplikasi">Nama Aplikasi</label>
							<input type="text" class="form-control" id="nama_aplikasi" name="nama_aplikasi" 
							value="<?php echo e(old('nama_aplikasi', $setting->nama_aplikasi ?? '')); ?>" required>
						</div>

						<div class="form-group">
							<label for="footer">Footer Text</label>
							<textarea class="form-control" id="footer" name="footer" rows="3"><?php echo e(old('footer', $setting->footer ?? '')); ?></textarea>
						</div>

						<div class="form-group">
							<label for="running_text">Teks Berjalan</label>
							<textarea class="form-control" id="running_text" name="running_text" rows="3"><?php echo e(old('running_text', $setting->running_text ?? '')); ?></textarea>
						</div>
					</div>

					<div class="col-md-6">
						<div class="form-group">
							<label for="favicon">Favicon</label>
							<div class="custom-file">
								<input type="file" class="custom-file-input" id="favicon" name="favicon">
								<label class="custom-file-label" for="favicon">Pilih file favicon</label>
							</div>
							<?php if($setting->favicon): ?>
							<div class="mt-3">
								<p class="mb-1">Favicon Saat Ini:</p>
								<img src="<?php echo e(asset('storage/' . $setting->favicon)); ?>" width="64" height="64" class="img-thumbnail d-block">
								<small class="text-muted">Rekomendasi: 64x64 px (format .ico atau .png)</small>
							</div>
							<?php endif; ?>
						</div>
					</div>
				</div>

				<hr class="my-4">

				<div class="row">
					<div class="col-md-6">
						<div class="form-group">
							<label for="logo">Logo Aplikasi</label>
							<div class="custom-file">
								<input type="file" class="custom-file-input" id="logo" name="logo">
								<label class="custom-file-label" for="logo">Pilih file logo</label>
							</div>
							<?php if($setting->logo): ?>
							<div class="mt-3">
								<p class="mb-1">Logo Saat Ini:</p>
								<img src="<?php echo e(asset('storage/' . $setting->logo)); ?>" class="img-thumbnail" style="max-height: 150px; width: auto;">
								<small class="text-muted">Rekomendasi: maksimal 300x150 px (format .png dengan background transparan)</small>
							</div>
							<?php endif; ?>
						</div>
					</div>

					<div class="col-md-6">
						<div class="form-group">
							<label for="background">Background Sidebar</label>
							<div class="custom-file">
								<input type="file" class="custom-file-input" id="background" name="background">
								<label class="custom-file-label" for="background">Pilih file background</label>
							</div>
							<?php if($setting->background): ?>
							<div class="mt-3">
								<p class="mb-1">Background Saat Ini:</p>
								<img src="<?php echo e(asset('storage/' . $setting->background)); ?>" class="img-thumbnail" style="max-height: 150px; width: 100%; object-fit: cover;">
								<small class="text-muted">Rekomendasi: 1920x1080 px (format .jpg atau .png)</small>
							</div>
							<?php endif; ?>
						</div>
					</div>
				</div>

				<div class="mt-4 text-right">
					<button type="submit" class="btn btn-primary">
						<i class="fas fa-save mr-2"></i> Simpan Perubahan
					</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Menampilkan nama file di input file
	document.querySelectorAll('.custom-file-input').forEach(function(input) {
		input.addEventListener('change', function(e) {
			var fileName = e.target.files[0] ? e.target.files[0].name : 'Pilih file';
			var nextSibling = e.target.nextElementSibling;
			nextSibling.innerText = fileName;
		});
	});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\PROJECT LARAVEL\DISPLAY-INFORMASI-MASJID\resources\views/settings/edit.blade.php ENDPATH**/ ?>