<!-- resources/views/users/index.blade.php -->


<?php $__env->startSection('main-content'); ?>
<div class="container">
	<h1>Kelola Akun</h1>
	<a href="<?php echo e(route('users.create')); ?>" class="btn btn-primary mb-3">Tambah Akun</a>
	<?php if(session('success')): ?>
	<div class="alert alert-success"><?php echo e(session('success')); ?></div>
	<?php endif; ?>
	<table class="table table-bordered">
		<thead>
			<tr>
				<th>Nama Lengkap</th>
				<th>Email</th>
				<th>Role</th> <!-- Menampilkan Role -->
				<th>Aksi</th>
			</tr>
		</thead>
		<tbody>
			<?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			<tr>
				<td><?php echo e($user->full_name); ?></td>
				<td><?php echo e($user->email); ?></td>
				<td><?php echo e($user->role ? $user->role->name : 'Tidak Ada Role'); ?></td> <!-- Menampilkan nama role -->
				<td>
					<a href="<?php echo e(route('users.edit', $user->id)); ?>" class="btn btn-sm btn-warning">Edit</a>
					<form action="<?php echo e(route('users.destroy', $user->id)); ?>" method="POST" style="display:inline;">
						<?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
						<button class="btn btn-sm btn-danger" onclick="return confirm('Yakin hapus akun ini?')">Hapus</button>
					</form>
				</td>
			</tr>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		</tbody>
	</table>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\PROJECT LARAVEL\DISPLAY-INFORMASI-MASJID\resources\views/users/index.blade.php ENDPATH**/ ?>