<!-- resources/views/keuangan/index.blade.php -->


<?php $__env->startSection('main-content'); ?>
<div class="container-fluid">
	<div class="d-sm-flex align-items-center justify-content-between mb-4">
		<h1 class="h3 mb-0 text-gray-800">Kelola Keuangan</h1>
		<a href="<?php echo e(route('keuangan.create')); ?>" class="btn btn-primary">Tambah Transaksi</a>
	</div>

	<?php if(session('success')): ?>
	<div class="alert alert-success alert-dismissible fade show" role="alert">
		<?php echo e(session('success')); ?>

		<button type="button" class="close" data-dismiss="alert" aria-label="Close">
			<span aria-hidden="true">&times;</span>
		</button>
	</div>
	<?php endif; ?>

	<?php if($errors->any()): ?>
	<div class="alert alert-danger">
		<ul class="mb-0">
			<?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			<li><?php echo e($error); ?></li>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		</ul>
	</div>
	<?php endif; ?>

	<div class="card shadow mb-4">
		<div class="card-header py-3">
			<h6 class="m-0 font-weight-bold text-primary">Ringkasan Keuangan</h6>
		</div>
		<div class="card-body">
			<div class="row">
				<div class="col-md-4">
					<p><strong>Total Pemasukan:</strong> Rp <?php echo e(number_format($totalPemasukan, 2, ',', '.')); ?></p>
				</div>
				<div class="col-md-4">
					<p><strong>Total Pengeluaran:</strong> Rp <?php echo e(number_format($totalPengeluaran, 2, ',', '.')); ?></p>
				</div>
				<div class="col-md-4">
					<p><strong>Saldo:</strong> Rp <?php echo e(number_format($saldo, 2, ',', '.')); ?></p>
				</div>
			</div>
		</div>
	</div>

	<div class="card shadow mb-4">
		<div class="card-header py-3">
			<h6 class="m-0 font-weight-bold text-primary">Daftar Transaksi</h6>
		</div>
		<div class="card-body">
			<div class="table-responsive">
				<table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
					<thead>
						<tr>
							<th>Tanggal</th>
							<th>Deskripsi</th>
							<th>Kategori</th>
							<th>Pemasukan</th>
							<th>Pengeluaran</th>
							<th>Saldo</th>
							<th>Aksi</th>
						</tr>
					</thead>
					<tbody>
						<?php $__currentLoopData = $keuangan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<tr>
							<td><?php echo e(\Carbon\Carbon::parse($item->tanggal)->translatedFormat('d F Y')); ?></td>
							<td><?php echo e($item->deskripsi); ?></td>
							<td><?php echo e($item->kategori ?? '-'); ?></td>
							<td>Rp <?php echo e(number_format($item->pemasukan, 2, ',', '.')); ?></td>
							<td>Rp <?php echo e(number_format($item->pengeluaran, 2, ',', '.')); ?></td>
							<td>Rp <?php echo e(number_format($item->saldo, 2, ',', '.')); ?></td>
							<td>
								<a href="<?php echo e(route('keuangan.edit', $item)); ?>" class="btn btn-sm btn-warning">Ubah</a>
								<form action="<?php echo e(route('keuangan.destroy', $item)); ?>" method="POST" style="display:inline;">
									<?php echo csrf_field(); ?>
									<?php echo method_field('DELETE'); ?>
									<button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Yakin ingin menghapus?')">Hapus</button>
								</form>
							</td>
						</tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\PROJECT LARAVEL\DISPLAY-INFORMASI-MASJID\resources\views/keuangan/index.blade.php ENDPATH**/ ?>