<!-- resources/views/about.blade.php -->

<?php $__env->startSection('title', 'Tentang Aplikasi'); ?>
<?php $__env->startSection('main-content'); ?>

<div class="row justify-content-center">
    <div class="col-lg-10">
        <!-- Main Card -->
        <div class="card shadow mb-4 border-left-primary">
            <!-- Card Header with Logo -->
            <div class="card-header py-3 text-center bg-gradient-primary text-white">
                <img src="<?php echo e(isset($setting['logo']) ? asset('storage/' . $setting['logo']) : asset('img/default-logo.png')); ?>"
                alt="Logo Aplikasi"
                class="img-fluid mb-3"
                style="max-width: 100px;">
                <h4 class="m-0 font-weight-bold"><?php echo e($setting->nama_aplikasi ?? 'Sistem Informasi Masjid Digital'); ?></h4>
                <p class="mb-0 small">Solusi Digital untuk Manajemen Masjid dengan Tampilan TV Dinamis</p>
            </div>

            <!-- Card Body -->
            <div class="card-body">
                <!-- Introduction -->
                <section class="mb-5">
                    <h5 class="font-weight-bold text-primary">Tentang Aplikasi Ini</h5>
                    <p class="text-justify">
                        <strong><?php echo e($setting->nama_aplikasi ?? 'Sistem Informasi Masjid Digital'); ?></strong> adalah solusi terintegrasi berbasis web untuk manajemen masjid modern yang dibangun dengan Laravel 12. Aplikasi ini menampilkan informasi masjid secara real-time pada layar TV digital dengan desain yang dinamis dan responsif.
                    </p>
                    <p class="text-justify">
                        Sistem ini dirancang khusus untuk menampilkan jadwal sholat, pengumuman, informasi keuangan, dan kegiatan masjid secara digital dengan tampilan yang elegan dan mudah dibaca dari jarak jauh. Dilengkapi dengan antarmuka admin yang lengkap untuk mengelola semua konten yang ditampilkan.
                    </p>
                </section>

                <!-- Main Features -->
                <section class="mb-5">
                    <h5 class="font-weight-bold text-primary">Fitur Utama</h5>
                    <div class="row">
                        <!-- Column 1 -->
                        <div class="col-md-4 mb-4">
                            <div class="card h-100 shadow-sm border-left-success">
                                <div class="card-body">
                                    <h6 class="font-weight-bold text-success"><i class="fas fa-tv mr-2"></i>Tampilan TV Dinamis</h6>
                                    <p class="small text-justify">
                                        Menampilkan informasi masjid secara real-time pada layar TV dengan desain modern dan animasi yang menarik.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-4">
                            <div class="card h-100 shadow-sm border-left-success">
                                <div class="card-body">
                                    <h6 class="font-weight-bold text-success"><i class="fas fa-clock mr-2"></i>Jadwal Sholat Otomatis</h6>
                                    <p class="small text-justify">
                                        Menampilkan jadwal sholat dengan waktu yang akurat dan update otomatis sesuai lokasi masjid.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-4">
                            <div class="card h-100 shadow-sm border-left-success">
                                <div class="card-body">
                                    <h6 class="font-weight-bold text-success"><i class="fas fa-money-bill-wave mr-2"></i>Laporan Keuangan</h6>
                                    <p class="small text-justify">
                                        Menampilkan informasi keuangan masjid secara transparan dengan grafik dan detail pemasukan/pengeluaran.
                                    </p>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Column 2 -->
                        <div class="col-md-4 mb-4">
                            <div class="card h-100 shadow-sm border-left-success">
                                <div class="card-body">
                                    <h6 class="font-weight-bold text-success"><i class="fas fa-bullhorn mr-2"></i>Pengumuman Digital</h6>
                                    <p class="small text-justify">
                                        Menampilkan pengumuman penting masjid secara bergulir dengan efek animasi yang menarik.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-4">
                            <div class="card h-100 shadow-sm border-left-success">
                                <div class="card-body">
                                    <h6 class="font-weight-bold text-success"><i class="fas fa-calendar-alt mr-2"></i>Kalender Kegiatan</h6>
                                    <p class="small text-justify">
                                        Menampilkan jadwal kegiatan dan acara masjid dalam bentuk kalender interaktif.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-4">
                            <div class="card h-100 shadow-sm border-left-success">
                                <div class="card-body">
                                    <h6 class="font-weight-bold text-success"><i class="fas fa-mobile-alt mr-2"></i>Responsive Design</h6>
                                    <p class="small text-justify">
                                        Tampilan yang optimal baik di TV layar lebar, monitor komputer, maupun perangkat mobile.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

                <!-- TV Display Features -->
                <section class="mb-5">
                    <h5 class="font-weight-bold text-primary">Fitur Tampilan TV</h5>
                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <div class="card shadow-sm h-100">
                                <div class="card-body text-center">
                                    <div class="bg-primary text-white rounded-circle mx-auto mb-3" style="width: 50px; height: 50px; line-height: 50px; font-size: 20px;">1</div>
                                    <h6 class="font-weight-bold">Tampilan Waktu</h6>
                                    <p class="small">Menampilkan waktu sholat, tanggal Hijriah & Masehi secara real-time</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 mb-3">
                            <div class="card shadow-sm h-100">
                                <div class="card-body text-center">
                                    <div class="bg-primary text-white rounded-circle mx-auto mb-3" style="width: 50px; height: 50px; line-height: 50px; font-size: 20px;">2</div>
                                    <h6 class="font-weight-bold">Running Text</h6>
                                    <p class="small">Pengumuman bergulir dengan kecepatan yang dapat disesuaikan</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 mb-3">
                            <div class="card shadow-sm h-100">
                                <div class="card-body text-center">
                                    <div class="bg-primary text-white rounded-circle mx-auto mb-3" style="width: 50px; height: 50px; line-height: 50px; font-size: 20px;">3</div>
                                    <h6 class="font-weight-bold">Animasi Kaligrafi</h6>
                                    <p class="small">Elemen kaligrafi Islami dengan efek visual yang indah</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 mb-3">
                            <div class="card shadow-sm h-100">
                                <div class="card-body text-center">
                                    <div class="bg-primary text-white rounded-circle mx-auto mb-3" style="width: 50px; height: 50px; line-height: 50px; font-size: 20px;">4</div>
                                    <h6 class="font-weight-bold">Multi-Layout</h6>
                                    <p class="small">Berbagai pilihan layout tampilan yang dapat diubah sesuai kebutuhan</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

                <!-- Admin Features -->
                <section class="mb-5">
                    <h5 class="font-weight-bold text-primary">Fitur Admin</h5>
                    <div class="card shadow-sm">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h6 class="font-weight-bold">Manajemen Konten</h6>
                                    <ul class="small">
                                        <li>Kelola jadwal sholat dan jadwal imam</li>
                                        <li>Posting pengumuman dan kegiatan masjid</li>
                                        <li>Input data keuangan dan laporan</li>
                                        <li>Atur tampilan TV (warna, font, layout)</li>
                                        <li>Upload gambar dan dokumen pendukung</li>
                                    </ul>
                                </div>
                                <div class="col-md-6">
                                    <h6 class="font-weight-bold">Sistem Keamanan</h6>
                                    <ul class="small">
                                        <li>Login dengan verifikasi dua faktor</li>
                                        <li>Pembatasan akses berdasarkan role</li>
                                        <li>Log aktivitas administrator</li>
                                        <li>Backup data otomatis</li>
                                        <li>Proteksi terhadap serangan cyber</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </section>

                    <!-- Technologies Used -->
                    <section class="mb-5">
                        <h5 class="font-weight-bold text-primary">Teknologi yang Digunakan</h5>
                        <div class="row">
                            <div class="col-md-3 mb-3">
                                <div class="card shadow-sm">
                                    <div class="card-body text-center">
                                        <img src="https://laravel.com/img/logomark.min.svg" alt="Laravel" style="height: 40px;" class="mb-2">
                                        <h6 class="font-weight-bold">Laravel 12</h6>
                                        <p class="small">Framework PHP untuk backend</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3 mb-3">
                                <div class="card shadow-sm">
                                    <div class="card-body text-center">
                                        <img src="https://getbootstrap.com/docs/5.0/assets/brand/bootstrap-logo.svg" alt="Bootstrap" style="height: 40px;" class="mb-2">
                                        <h6 class="font-weight-bold">Bootstrap 5</h6>
                                        <p class="small">Framework CSS untuk frontend</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3 mb-3">
                                <div class="card shadow-sm">
                                    <div class="card-body text-center">
                                        <img src="https://vuejs.org/images/logo.png" alt="Vue.js" style="height: 40px;" class="mb-2">
                                        <h6 class="font-weight-bold">Vue.js</h6>
                                        <p class="small">Framework JavaScript untuk tampilan dinamis</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3 mb-3">
                                <div class="card shadow-sm">
                                    <div class="card-body text-center">
                                        <img src="https://www.mysql.com/common/logos/logo-mysql-170x115.png" alt="MySQL" style="height: 40px;" class="mb-2">
                                        <h6 class="font-weight-bold">MySQL</h6>
                                        <p class="small">Database management system</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>

                    <!-- Quick Guide -->
                    <section class="mb-5">
                        <h5 class="font-weight-bold text-primary">Panduan Penggunaan</h5>
                        <div class="card shadow-sm">
                            <div class="card-body">
                                <div class="accordion" id="usageGuide">
                                    <div class="card">
                                        <div class="card-header" id="headingOne">
                                            <h6 class="mb-0">
                                                <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#collapseOne">
                                                    <i class="fas fa-plus-circle mr-2"></i>Menampilkan di TV
                                                </button>
                                            </h6>
                                        </div>
                                        <div id="collapseOne" class="collapse show" data-parent="#usageGuide">
                                            <div class="card-body small">
                                                1. Buka browser di perangkat yang terhubung ke TV<br>
                                                2. Akses alamat aplikasi (contoh: http://masjidanda.tv)<br>
                                                3. Tekan F11 untuk mode layar penuh<br>
                                                4. Atur resolusi sesuai dengan layar TV<br>
                                                5. Sistem akan menampilkan informasi secara otomatis
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card">
                                        <div class="card-header" id="headingTwo">
                                            <h6 class="mb-0">
                                                <button class="btn btn-link collapsed" type="button" data-toggle="collapse" data-target="#collapseTwo">
                                                    <i class="fas fa-plus-circle mr-2"></i>Update Jadwal Sholat
                                                </button>
                                            </h6>
                                        </div>
                                        <div id="collapseTwo" class="collapse" data-parent="#usageGuide">
                                            <div class="card-body small">
                                                1. Login sebagai admin<br>
                                                2. Akses menu Jadwal Sholat<br>
                                                3. Input waktu sholat sesuai lokasi masjid<br>
                                                4. Atur jadwal imam dan muadzin<br>
                                                5. Sistem akan update otomatis di tampilan TV
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card">
                                        <div class="card-header" id="headingThree">
                                            <h6 class="mb-0">
                                                <button class="btn btn-link collapsed" type="button" data-toggle="collapse" data-target="#collapseThree">
                                                    <i class="fas fa-plus-circle mr-2"></i>Posting Pengumuman
                                                </button>
                                            </h6>
                                        </div>
                                        <div id="collapseThree" class="collapse" data-parent="#usageGuide">
                                            <div class="card-body small">
                                                1. Login sebagai admin<br>
                                                2. Akses menu Pengumuman<br>
                                                3. Buat pengumuman baru<br>
                                                4. Atur tanggal dan prioritas tampilan<br>
                                                5. Pengumuman akan muncul di running text TV
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>

                    <!-- Developer Info -->
                    <section class="text-center">
                        <div class="card shadow-sm">
                            <div class="card-body">
                                <?php echo $setting->footer ?? '<p class="small text-muted">Dikembangkan oleh <a href="https://wa.me/628179851011" target="_blank" class="text-primary">Ali Mochtar Development System</a></p>'; ?>

                                <p class="small text-muted mt-2">Versi Aplikasi: 2.0.0 (Update: <?php echo e(now()->format('d F Y')); ?>)</p>
                                <?php if($setting->footer_contact): ?>
                                <p class="small text-muted mt-1">Kontak: <?php echo e($setting->footer_contact); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </section>
                </div>
            </div>
        </div>
    </div>

<!-- Custom CSS -->
<style>
    .card-header.bg-gradient-primary {
        background: linear-gradient(135deg, #0a4d68, #088395);
    }
    .border-left-primary {
        border-left: 4px solid #0a4d68;
    }
    .border-left-success {
        border-left: 4px solid #00a86b;
    }
    .accordion .card-header {
        background-color: rgba(10, 77, 104, 0.05);
    }
    .btn-link {
        color: #0a4d68;
        text-decoration: none;
    }
    .btn-link:hover {
        color: #088395;
    }
    .text-primary {
        color: #0a4d68 !important;
    }
</style>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\PROJECT LARAVEL\DISPLAY-INFORMASI-MASJID\resources\views/about.blade.php ENDPATH**/ ?>